

<!-- Make sure you put this AFTER Leaflet's CSS -->

  <script src="https://unpkg.com/leaflet@1.3.4/dist/leaflet.js" integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA=="

   crossorigin=""></script>

 <!-- <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/> -->



 <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCHqhgVQmhdp3XAJ91LHRdXJ3YOjP1V2Gs" async defer></script> 





 <script src="assets/js/leaflet-panel-layers-master/src/leaflet-panel-layers.js"></script>

 <script src="assets/js/leaflet-compass-master/src/leaflet-compass.js"></script>

 <script src="assets/js/leaflet-search/dist/leaflet-search.src.js"></script>



 <script src="assets/js/leaflet.ajax.js"></script>

 <script src="assets/js/Leaflet.GoogleMutant.js"></script>



   <script type="text/javascript">



   	// var map = L.map('mapid').setView([3.2352436, 99.3412807], 10);

		var map = L.map('mapid').setView([3.2304447,99.315189], 11);

		map.zoomControl.setPosition('topright');



    var LayerKita = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {

          maxZoom: 19,

          attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'

    });

    var roadMutant = L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'roadmap'

		});

	map.addLayer(LayerKita);



	var myStyle2 = {

	    "color": "#ffff00",

	    "weight": 1,

	    "opacity": 0.9

	};



	function popUp(f,l){

	    var out = [];

	    if (f.properties){

					for(key in f.properties){

              out.push(key+": "+f.properties[key]);

          }

          l.bindPopup(out.join("<br />"));

	    }

	}





	// legend



	function iconByName(name) {

		return '<i class="icon" style="background-color:'+name+';border-radius:50%"></i>';

	}



	function featureToMarker(feature, latlng) {

		return L.marker(latlng, {

			icon: L.divIcon({

				className: 'marker-'+feature.properties.amenity,

				html: iconByName(feature.properties.amenity),

				iconUrl: '../images/markers/'+feature.properties.amenity+'.png',

				iconSize: [25, 41],

				iconAnchor: [12, 41],

				popupAnchor: [1, -34],

				shadowSize: [41, 41]

			})

		});

	}



	var baseLayers = [

		{

			name: "OpenStreetMap",

			layer: LayerKita

		},

		{

			name: "OpenCycleMap",

			layer: L.tileLayer('http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png')

		},

		{

			name: "Outdoors",

			layer: L.tileLayer('http://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png')

		},

		{

			name:'Satelite Google',

			layer : L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'satellite'

			})

		},

		{

			name: "Roadmap Google",

			layer: roadMutant

		}

	];



	<?php

		$db->where('nm_koordinat','Batas Kecamatan');

		$getKec=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getKec as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arrayKec[]='{

			name: "Kecamatan",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		$db->where('nm_koordinat','Batas Desa');

		$getDesa=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getDesa as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arrayDesa[]='{

			name: "Kelurahan/Desa",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		$db->where('nm_koordinat','Sawah');

		$getSawah=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getSawah as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arraySawah[]='{

			name: "Sawah",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		$db->where('nm_koordinat','Irigasi');

		$getIrigasi=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getIrigasi as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arrayIrigasi[]='{

			name: "Irigasi",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		$db->where('nm_koordinat','Jalan');

		$getJalan=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getJalan as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arrayJalan[]='{

			name: "Jalan Kabupaten",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		$db->where('nm_koordinat','JUTani');

		$getJUT=$db->ObjectBuilder()->get('m_koordinat');

		foreach ($getJUT as $row) {

			?>



			var myStyle<?=$row->id_koordinat?> = {

			    "color": "<?=$row->warna_koordinat?>",

			    "weight": 1,

			    "opacity": 1

			};



			<?php

			$arrayJUT[]='{

			active: false,

			name: "Jalan Usaha Tani",

			icon: iconByName("'.$row->warna_koordinat.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$row->geojson_koordinat.'"],{onEachFeature:popUp,style: myStyle'.$row->id_koordinat.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	

	var overLayers = [

		{

			group: "Batas Administrasi",

			layers: [

				<?=implode(',', $arrayKec);?>

			]	

		},

		{

			group: "Batas Administrasi",

			layers: [

				<?=implode(',', $arrayDesa);?>

			]

		},

		{

			group: "Batas Pertanian",

			layers: [

				<?=implode(',', $arraySawah);?>

			]

		},

		{

			group: "Batas Pertanian",

			layers: [

				<?=implode(',', $arrayIrigasi);?>

			]

		},

		{

			group: "Batas Jalan",

			layers: [

				<?=implode(',', $arrayJalan);?>

			]

		},

		{

			group: "Batas Jalan",

			layers: [

				<?=implode(',', $arrayJUT);?>

			]

		}

	];



	

	var panelLayers = new L.Control.PanelLayers(baseLayers, overLayers,{

		position:'topleft',

		selectorGroup: true,

		collapsibleGroups: true

	});



	map.addControl(panelLayers);

	// map.addControl( new L.Control.Compass({

	// 	position:'topleft',

	// 	autoActive:true,

	// 	showDigit:true

	// }) );







   </script>

